<div class="max-w-2xl mx-auto">
    <!-- Search Header -->
    <div class="border-b border-slate-200 p-4 sticky top-0 bg-white/80 backdrop-blur">
        <h2 class="text-2xl font-bold text-slate-900">Search Results</h2>
        <p class="text-sm text-slate-600">Find posts, announcements, and fellow students</p>
    </div>

    <!-- Search Form -->
    <div class="border-b border-slate-200 p-4">
        <form method="get" class="flex gap-2">
            <input
                type="text"
                name="q"
                value="<?= htmlspecialchars($query) ?>"
                placeholder="Search keywords..."
                class="flex-1 bg-slate-50 border border-slate-300 rounded-lg px-4 py-2 text-sm text-slate-900 placeholder:text-slate-500 focus:border-emerald-500 focus:outline-none"
            >
            <button
                type="submit"
                class="bg-emerald-700 hover:bg-emerald-800 text-white text-sm font-bold px-6 py-2 rounded-lg transition"
            >
                🔍 Search
            </button>
        </form>
    </div>

    <?php if ($query === ''): ?>
        <div class="p-4 text-center text-slate-600">
            <p class="text-sm">Enter a keyword to begin searching.</p>
        </div>
    <?php else: ?>
        <div class="divide-y divide-slate-200">
            <!-- Posts Results -->
            <section class="p-4 space-y-3">
                <h3 class="font-bold text-lg text-slate-900">📝 Posts (<?= count($results['posts']) ?>)</h3>
                <?php if (empty($results['posts'])): ?>
                    <p class="text-sm text-slate-600">No matching posts found.</p>
                <?php else: ?>
                    <div class="space-y-2">
                        <?php foreach ($results['posts'] as $p): ?>
                            <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="block bg-slate-50 rounded-lg p-3 hover:bg-emerald-50 transition border border-slate-200">
                                <p class="font-semibold text-slate-900">
                                    <?= htmlspecialchars($p['title']) ?>
                                </p>
                                <p class="text-xs text-slate-600 mt-1">By <?= htmlspecialchars($p['full_name'] ?? 'User') ?></p>
                                <p class="text-sm text-slate-700 mt-1 line-clamp-2">
                                    <?= htmlspecialchars(mb_substr($p['body'], 0, 150)) ?>...
                                </p>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>

            <!-- Announcements Results -->
            <section class="p-4 space-y-3">
                <h3 class="font-bold text-lg text-slate-900">📢 Announcements (<?= count($results['announcements']) ?>)</h3>
                <?php if (empty($results['announcements'])): ?>
                    <p class="text-sm text-slate-600">No matching announcements found.</p>
                <?php else: ?>
                    <div class="space-y-2">
                        <?php foreach ($results['announcements'] as $a): ?>
                            <div class="bg-slate-50 rounded-lg p-3 border border-emerald-200">
                                <p class="font-semibold text-emerald-700">
                                    <?= htmlspecialchars($a['title']) ?>
                                </p>
                                <p class="text-sm text-slate-700 mt-1 line-clamp-2">
                                    <?= htmlspecialchars(mb_substr($a['body'], 0, 150)) ?>...
                                </p>
                                <p class="text-xs text-slate-600 mt-1">
                                    <?= htmlspecialchars($a['created_at']) ?>
                                </p>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>

            <!-- Users Results -->
            <section class="p-4 space-y-3">
                <h3 class="font-bold text-lg text-slate-900">👥 Students (<?= count($results['users']) ?>)</h3>
                <?php if (empty($results['users'])): ?>
                    <p class="text-sm text-slate-600">No matching students found.</p>
                <?php else: ?>
                    <div class="space-y-2">
                        <?php foreach ($results['users'] as $u): ?>
                            <div class="bg-slate-50 rounded-lg p-3 border border-slate-200 hover:bg-emerald-50 transition">
                                <p class="font-semibold text-slate-900">
                                    <?= htmlspecialchars($u['full_name'] ?? $u['student_id'] ?? 'User') ?>
                                </p>
                                <p class="text-xs text-slate-600 mt-0.5">
                                    🏫 <?= htmlspecialchars($u['institution'] ?? 'Unknown') ?>
                                </p>
                                <?php if (!empty($u['programme'])): ?>
                                    <p class="text-xs text-slate-600">
                                        📚 <?= htmlspecialchars($u['programme']) ?>
                                    </p>
                                <?php endif; ?>
                                <p class="text-xs text-slate-700 mt-1">
                                    ID: <?= htmlspecialchars($u['student_id']) ?>
                                </p>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </section>
        </div>
    <?php endif; ?>
</div>

