<div class="max-w-3xl">
    <!-- Profile Header with Image -->
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6 mb-4">
        <div class="flex items-center gap-4 mb-4">
            <!-- Profile Image -->
            <div class="flex-shrink-0">
                <?php
                $profileImage = $user['profile_image'] ?? null;
                $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                ?>
                <?php if ($imageUrl): ?>
                    <img src="<?= $imageUrl ?>" alt="Profile Image" class="w-24 h-24 rounded-full object-cover border-2 border-emerald-500">
                <?php else: ?>
                    <div class="w-24 h-24 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white text-2xl font-bold">
                        <?= strtoupper(substr($user['full_name'] ?? 'U', 0, 1)) ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Profile Info -->
            <div>
                <h1 class="text-2xl font-bold text-slate-900 mb-1"><?= htmlspecialchars($user['full_name'] ?? 'User') ?></h1>
                <p class="text-sm text-slate-600 mb-2">Student ID: <span class="font-mono text-slate-800"><?= htmlspecialchars($_SESSION['user']['student_id']) ?></span></p>
                <p class="text-sm text-slate-600"><?= htmlspecialchars($user['institution'] ?? 'Institution') ?></p>
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <?php if (!empty($success)): ?>
        <div class="mb-4 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">
            ✓ <?= htmlspecialchars($success) ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700 space-y-1">
            <?php foreach ($errors as $error): ?>
                <p>✗ <?= htmlspecialchars($error) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($pwdSuccess)): ?>
        <div class="mb-4 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">
            ✓ <?= htmlspecialchars($pwdSuccess) ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($pwdErrors)): ?>
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700 space-y-1">
            <?php foreach ($pwdErrors as $error): ?>
                <p>✗ <?= htmlspecialchars($error) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Personal Information -->
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6 mb-4">
        <h2 class="text-lg font-semibold text-slate-900 mb-4">Personal Information</h2>
        
        <form method="post" action="<?= BASE_URL ?>/profile/update" class="space-y-4" enctype="multipart/form-data">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
            
            <!-- Profile Image Upload -->
            <div class="border-b pb-4 mb-4">
                <label class="block text-sm font-medium text-slate-700 mb-2" for="profile_image">Profile Picture</label>
                <div class="flex items-center gap-4">
                    <div class="flex-shrink-0">
                        <?php
                        $profileImage = $user['profile_image'] ?? null;
                        $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                        ?>
                        <?php if ($imageUrl): ?>
                            <img src="<?= $imageUrl ?>" alt="Current Profile" class="w-16 h-16 rounded-full object-cover border-2 border-emerald-500">
                        <?php else: ?>
                            <div class="w-16 h-16 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white font-bold">
                                <?= strtoupper(substr($user['full_name'] ?? 'U', 0, 1)) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="flex-1">
                        <input
                            type="file"
                            id="profile_image"
                            name="profile_image"
                            accept="image/jpeg,image/png,image/gif,image/webp"
                            class="block w-full text-sm text-slate-500 file:mr-3 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-emerald-50 file:text-emerald-700 hover:file:bg-emerald-100"
                        >
                        <p class="text-xs text-slate-500 mt-1">JPG, PNG, GIF or WebP. Max 5MB.</p>
                    </div>
                </div>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="full_name">Full Name</label>
                <input
                    type="text"
                    id="full_name"
                    name="full_name"
                    required
                    value="<?= htmlspecialchars($user['full_name'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="institution">Institution</label>
                <input
                    type="text"
                    id="institution"
                    name="institution"
                    required
                    value="<?= htmlspecialchars($user['institution'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="programme">Programme / Field of Study</label>
                <input
                    type="text"
                    id="programme"
                    name="programme"
                    required
                    value="<?= htmlspecialchars($user['programme'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <hr class="my-4 border-slate-200">

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="email">Email Address</label>
                <input
                    type="email"
                    id="email"
                    name="email"
                    value="<?= htmlspecialchars($user['email'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="phone">Phone Number</label>
                <input
                    type="tel"
                    id="phone"
                    name="phone"
                    value="<?= htmlspecialchars($user['phone'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="location">Location / City</label>
                <input
                    type="text"
                    id="location"
                    name="location"
                    value="<?= htmlspecialchars($user['location'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="address">Street Address</label>
                <input
                    type="text"
                    id="address"
                    name="address"
                    value="<?= htmlspecialchars($user['address'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="country">Country</label>
                <input
                    type="text"
                    id="country"
                    name="country"
                    value="<?= htmlspecialchars($user['country'] ?? '') ?>"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <button
                type="submit"
                class="bg-emerald-700 hover:bg-emerald-800 text-white text-sm font-medium px-4 py-2 rounded-lg transition"
            >
                Save Changes
            </button>
        </form>
    </div>

    <!-- Change Password -->
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-6">
        <h2 class="text-lg font-semibold text-slate-900 mb-4">Change Password</h2>
        
        <form method="post" action="<?= BASE_URL ?>/profile/changePassword" class="space-y-4">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
            
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="current_password">Current Password</label>
                <input
                    type="password"
                    id="current_password"
                    name="current_password"
                    required
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="new_password">New Password</label>
                <input
                    type="password"
                    id="new_password"
                    name="new_password"
                    required
                    minlength="8"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                    placeholder="At least 8 characters"
                >
            </div>

            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1" for="confirm_password">Confirm New Password</label>
                <input
                    type="password"
                    id="confirm_password"
                    name="confirm_password"
                    required
                    minlength="8"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500"
                >
            </div>

            <button
                type="submit"
                class="bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium px-4 py-2 rounded-lg transition"
            >
                Change Password
            </button>
        </form>
    </div>
</div>
