<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">Notifications</h1>
    <form method="post" action="<?= BASE_URL ?>/notifications/markAllRead">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
        <button class="text-xs inline-flex items-center gap-1 px-3 py-1.5 rounded-full border border-slate-200 hover:bg-slate-50 text-slate-700">
            Mark all as read
        </button>
    </form>
</div>

<?php if (empty($notifications)): ?>
    <p class="text-sm text-slate-500">No notifications yet.</p>
<?php else: ?>
    <ul class="space-y-3">
        <?php foreach ($notifications as $n): ?>
            <li class="bg-white rounded-xl shadow-sm border border-slate-200 p-4">
                <p class="text-xs font-medium text-slate-600 mb-1">
                    Type: <?= htmlspecialchars($n['type']) ?>
                </p>
                <p class="text-sm text-slate-800">
                    <?= htmlspecialchars($n['data']) ?>
                </p>
                <p class="text-[11px] text-slate-400 mt-1">
                    <?= htmlspecialchars($n['created_at']) ?>
                    <?= $n['is_read'] ? '(read)' : '(unread)' ?>
                </p>
            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>

