<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">Messages</h1>
    <a href="<?= BASE_URL ?>/messages/compose" class="text-xs sm:text-sm inline-flex items-center gap-1 bg-emerald-700 text-white px-3 py-1.5 rounded-lg hover:bg-emerald-800">
        New Message
    </a>
</div>

<div class="grid md:grid-cols-2 gap-4">
    <section class="bg-white rounded-xl shadow-sm border border-slate-200 p-4">
        <h2 class="text-sm font-semibold text-slate-800 mb-2">Inbox</h2>
        <?php if (empty($inbox)): ?>
            <p class="text-xs text-slate-500">No incoming messages.</p>
        <?php else: ?>
            <ul class="space-y-2 text-xs">
                <?php foreach ($inbox as $m): ?>
                    <li class="border border-slate-100 rounded-lg px-3 py-2 bg-slate-50">
                        <p class="font-medium text-slate-800">
                            From <?= htmlspecialchars($m['sender_name'] ?? $m['sender_student_id']) ?>
                        </p>
                        <p class="text-slate-600 mt-0.5 line-clamp-2">
                            <?= htmlspecialchars(mb_substr($m['body'], 0, 120)) ?><?= mb_strlen($m['body']) > 120 ? '…' : '' ?>
                        </p>
                        <p class="text-[10px] text-slate-400 mt-1">
                            <?= htmlspecialchars($m['created_at']) ?>
                        </p>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </section>

    <section class="bg-white rounded-xl shadow-sm border border-slate-200 p-4">
        <h2 class="text-sm font-semibold text-slate-800 mb-2">Sent</h2>
        <?php if (empty($sent)): ?>
            <p class="text-xs text-slate-500">No sent messages yet.</p>
        <?php else: ?>
            <ul class="space-y-2 text-xs">
                <?php foreach ($sent as $m): ?>
                    <li class="border border-slate-100 rounded-lg px-3 py-2">
                        <p class="font-medium text-slate-800">
                            To <?= htmlspecialchars($m['receiver_name'] ?? $m['receiver_student_id']) ?>
                        </p>
                        <p class="text-slate-600 mt-0.5 line-clamp-2">
                            <?= htmlspecialchars(mb_substr($m['body'], 0, 120)) ?><?= mb_strlen($m['body']) > 120 ? '…' : '' ?>
                        </p>
                        <p class="text-[10px] text-slate-400 mt-1">
                            <?= htmlspecialchars($m['created_at']) ?>
                        </p>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </section>
</div>

