<?php
// $viewFile is set in Controller::view
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($title ?? 'EELL Community') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white text-slate-900 min-h-screen">
    <div class="grid grid-cols-1 md:grid-cols-4 lg:grid-cols-5 gap-0 min-h-screen">
        <!-- Left Sidebar Navigation -->
        <aside class="hidden md:flex md:col-span-1 lg:col-span-1 flex-col bg-gradient-to-b from-emerald-700 to-emerald-800 text-white p-3 sticky top-0 h-screen overflow-y-auto">
            <div class="mb-6 flex items-center gap-2 px-2">
                <div class="h-8 w-8 rounded-full bg-white flex items-center justify-center text-emerald-700 font-bold text-sm">
                    E
                </div>
                <span class="font-bold text-sm hidden lg:inline">EELL</span>
            </div>

            <nav class="space-y-2 flex-1">
                <a href="<?= BASE_URL ?>/" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                    <span class="text-lg">🏠</span> <span class="hidden lg:inline">Home</span>
                </a>
                <?php if (!empty($_SESSION['user'])): ?>
                    <a href="<?= BASE_URL ?>/dashboard" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">📊</span> <span class="hidden lg:inline">Dashboard</span>
                    </a>
                    <a href="<?= BASE_URL ?>/posts" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">🌍</span> <span class="hidden lg:inline">Community</span>
                    </a>
                    <a href="<?= BASE_URL ?>/messages" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">💬</span> <span class="hidden lg:inline">Messages</span>
                    </a>
                    <a href="<?= BASE_URL ?>/notifications" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">🔔</span> <span class="hidden lg:inline">Notifications</span>
                    </a>
                    <a href="<?= BASE_URL ?>/announcements" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">📢</span> <span class="hidden lg:inline">Announcements</span>
                    </a>
                    <?php if (!empty($_SESSION['user']) && $_SESSION['user']['role'] === 'admin'): ?>
                        <hr class="border-emerald-600 my-2">
                        <a href="<?= BASE_URL ?>/admin" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition font-semibold">
                            <span class="text-lg">⚙️</span> <span class="hidden lg:inline">Admin Panel</span>
                        </a>
                        <a href="<?= BASE_URL ?>/admin/users" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                            <span class="text-lg">👥</span> <span class="hidden lg:inline">User Management</span>
                        </a>
                        <a href="<?= BASE_URL ?>/admin/announcements" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                            <span class="text-lg">📰</span> <span class="hidden lg:inline">Announcements</span>
                        </a>
                    <?php endif; ?>
                <?php else: ?>
                    <a href="<?= BASE_URL ?>/announcements" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <span class="text-lg">📢</span> <span class="hidden lg:inline">Announcements</span>
                    </a>
                <?php endif; ?>
            </nav>

            <?php if (!empty($_SESSION['user'])): ?>
                <div class="space-y-2 mb-3 border-t border-emerald-600 pt-3">
                    <a href="<?= BASE_URL ?>/profile" class="flex items-center gap-3 p-2 rounded-lg hover:bg-emerald-600 text-sm transition">
                        <!-- Profile Image -->
                        <?php
                        $profileImage = $_SESSION['user']['profile_image'] ?? null;
                        $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                        ?>
                        <?php if ($imageUrl): ?>
                            <img src="<?= $imageUrl ?>" alt="Profile" class="w-6 h-6 rounded-full object-cover border border-white">
                        <?php else: ?>
                            <div class="w-6 h-6 rounded-full bg-white flex items-center justify-center text-emerald-700 text-xs font-bold">
                                <?= strtoupper(substr($_SESSION['user']['name'] ?? 'U', 0, 1)) ?>
                            </div>
                        <?php endif; ?>
                        <span class="hidden lg:inline"><?= htmlspecialchars(substr($_SESSION['user']['name'] ?? 'Profile', 0, 12)) ?></span>
                    </a>
                </div>
                <form action="<?= BASE_URL ?>/auth/logout" method="post">
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                    <button class="w-full bg-white hover:bg-slate-100 text-emerald-700 font-bold py-2 px-2 rounded-lg transition text-xs">
                        Logout
                    </button>
                </form>
            <?php else: ?>
                <a href="<?= BASE_URL ?>/auth/login" class="block text-center bg-white hover:bg-slate-100 text-emerald-700 font-bold py-2 px-2 rounded-lg transition text-xs mb-2">
                    Sign In
                </a>
                <a href="<?= BASE_URL ?>/auth/register" class="block text-center border-2 border-white text-white font-bold py-2 px-2 rounded-lg hover:bg-emerald-600 transition text-xs">
                    Join
                </a>
            <?php endif; ?>
        </aside>

        <!-- Center Content Feed -->
        <main class="col-span-1 md:col-span-2 lg:col-span-2 border-r border-slate-200 max-h-screen overflow-y-auto bg-slate-50">
            <div class="border-b border-slate-200 p-4 sticky top-0 bg-white/90 backdrop-blur shadow-sm">
                <h2 class="text-lg font-bold text-slate-900"><?= htmlspecialchars($title ?? 'Feed') ?></h2>
            </div>
            
            <div class="p-4 space-y-4">
                <?php require $viewFile; ?>
            </div>
        </main>

        <!-- Right Sidebar -->
        <aside class="hidden lg:flex lg:col-span-1 flex-col p-4 space-y-4 sticky top-0 h-screen overflow-y-auto bg-slate-50">
            <!-- Search -->
            <form action="<?= BASE_URL ?>/search" method="get" class="bg-white rounded-xl px-4 py-3 flex items-center gap-2 shadow-sm border border-slate-200">
                <span class="text-slate-600 text-sm">🔍</span>
                <input type="text" name="q" placeholder="Search..." class="w-full bg-transparent outline-none text-sm placeholder:text-slate-500" required>
            </form>

            <!-- What's Happening / Featured -->
            <?php if (!empty($_SESSION['user'])): ?>
                <div class="bg-white rounded-xl p-4 space-y-3 border border-slate-200 shadow-sm">
                    <h3 class="text-sm font-bold text-slate-900">🔥 Trending</h3>
                    
                    <?php 
                    // Get trending posts for the sidebar
                    $trendingModel = new Post();
                    $trendingItems = $trendingModel->getTrending(3);
                    
                    if (!empty($trendingItems)):
                        foreach ($trendingItems as $item):
                    ?>
                        <a href="<?= BASE_URL ?>/posts/show/<?= (int)$item['id'] ?>" class="block bg-slate-50 rounded-lg p-3 hover:bg-emerald-50 cursor-pointer transition border border-slate-200 hover:shadow-sm">
                            <p class="text-xs font-bold text-slate-900 line-clamp-2"><?= htmlspecialchars(mb_substr($item['title'], 0, 40)) ?></p>
                            <p class="text-xs text-slate-600 mt-1">
                                ❤️ <?= (int)($item['likes_count'] ?? 0) ?> 💬 <?= (int)($item['comments_count'] ?? 0) ?>
                            </p>
                        </a>
                    <?php 
                        endforeach;
                    else:
                    ?>
                        <p class="text-xs text-slate-600">No trending posts yet.</p>
                    <?php 
                    endif;
                    ?>
                </div>
            <?php else: ?>
                <div class="bg-white rounded-xl p-4 border border-slate-200 shadow-sm">
                    <h3 class="text-sm font-bold text-slate-900 mb-2">👋 Welcome</h3>
                    <p class="text-xs text-slate-700 mb-3">
                        Join students across Ghana discussing climate and environment.
                    </p>
                    <a href="<?= BASE_URL ?>/auth/register" class="block w-full text-center bg-emerald-700 hover:bg-emerald-800 text-white font-bold py-2 rounded-lg transition text-xs">
                        Join Now
                    </a>
                </div>
            <?php endif; ?>
        </aside>
    </div>

    <!-- Mobile Header -->
    <div class="md:hidden fixed top-0 left-0 right-0 border-b border-slate-200 bg-white z-50 p-3">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-2">
                <div class="h-8 w-8 rounded-full bg-emerald-700 flex items-center justify-center text-white font-bold text-sm">
                    E
                </div>
                <span class="font-bold text-emerald-700 text-sm">EELL</span>
            </div>
            <?php if (!empty($_SESSION['user'])): ?>
                <a href="<?= BASE_URL ?>/posts/create" class="bg-emerald-700 text-white px-3 py-1 rounded-full font-bold text-xs">
                    Post
                </a>
            <?php endif; ?>
        </div>
    </div>

    <style>
        body {
            scrollbar-width: thin;
            scrollbar-color: #d1d5db #f3f4f6;
        }
    </style>
</body>
</html>

