<section class="grid gap-6 lg:grid-cols-5">
    <div class="lg:col-span-3 space-y-4">
        <h1 class="text-2xl sm:text-3xl font-bold text-slate-800">
            Environmental Education & Lifelong Learning Community
        </h1>
        <p class="text-slate-600 text-sm sm:text-base">
            A national digital space for Ghanaian students to learn, share, and act on climate and environmental issues,
            coordinated by <span class="font-semibold">PACCPOLICY</span>.
        </p>

        <!-- Pinned Announcements - TOP PRIORITY -->
        <?php if (!empty($pinnedAnnouncements)): ?>
            <div class="bg-gradient-to-br from-amber-50 to-orange-50 border-2 border-amber-200 rounded-xl shadow-sm p-5 space-y-4">
                <h2 class="font-semibold text-amber-900 flex items-center gap-2">
                    <span class="text-lg">📌</span>
                    Pinned Announcements
                    <span class="text-[11px] uppercase tracking-wide text-orange-700 bg-orange-100 px-2 py-0.5 rounded-full ml-auto">
                        PRIORITY
                    </span>
                </h2>
                <div class="space-y-4">
                    <?php foreach ($pinnedAnnouncements as $a): ?>
                        <div class="bg-white border border-amber-200 rounded-lg overflow-hidden hover:shadow-md transition">
                            <!-- Media First -->
                            <?php
                            $announcementModel = new Announcement();
                            $announcementMedia = $announcementModel->getMedia((int)$a['id']);
                            if (!empty($announcementMedia)): ?>
                                <div class="grid grid-cols-2 gap-1 max-h-48 overflow-hidden">
                                    <?php foreach (array_slice($announcementMedia, 0, 2) as $m): ?>
                                        <?php if ($m['media_type'] === 'image'): ?>
                                            <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Announcement media" class="w-full h-32 object-cover">
                                        <?php else: ?>
                                            <div class="w-full h-32 flex items-center justify-center bg-slate-800">
                                                <span class="text-2xl">🎬</span>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Content -->
                            <div class="px-4 py-3">
                                <p class="font-medium text-amber-950 line-clamp-2">
                                    <?= htmlspecialchars($a['title']) ?>
                                </p>
                                <p class="text-sm text-amber-900/80 line-clamp-2 mt-2">
                                    <?= htmlspecialchars(mb_substr($a['body'], 0, 140)) ?><?= mb_strlen($a['body']) > 140 ? '…' : '' ?>
                                </p>
                                <p class="text-[10px] text-amber-700 mt-2">
                                    By <?= htmlspecialchars($a['full_name'] ?? 'PACCPOLICY') ?> · <?= htmlspecialchars($a['created_at']) ?>
                                </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Recent Posts and Announcements from Community -->
        <div class="space-y-2">
            <div class="flex items-center justify-between">
                <h2 class="font-semibold text-slate-800 text-lg">Community Feed</h2>
                <?php if (!empty($_SESSION['user'])): ?>
                    <a href="<?= BASE_URL ?>/posts/create" class="text-xs bg-emerald-700 hover:bg-emerald-800 text-white px-3 py-1.5 rounded-lg">
                        New Post
                    </a>
                <?php endif; ?>
            </div>

            <?php if (empty($recentPosts) && empty($announcements)): ?>
                <p class="text-slate-500 text-sm bg-white rounded-lg border border-slate-200 p-4">
                    No posts yet. Be the first to start a discussion!
                </p>
            <?php else: ?>
                <div class="space-y-5">
                    <!-- Display Announcements in Community Feed -->
                    <?php if (!empty($announcements)): ?>
                        <?php foreach ($announcements as $a): ?>
                            <article class="bg-gradient-to-br from-blue-50 to-cyan-50 rounded-xl shadow-sm border-2 border-blue-200 overflow-hidden hover:shadow-lg transition">
                                <!-- Announcement Badge -->
                                <div class="px-5 pt-4 pb-2 flex items-center gap-2">
                                    <span class="text-lg">📢</span>
                                    <span class="text-xs font-bold uppercase tracking-wide bg-blue-600 text-white px-2 py-1 rounded-full">
                                        Announcement
                                    </span>
                                    <?php if (!empty($a['pinned'])): ?>
                                        <span class="text-xs font-bold uppercase tracking-wide bg-orange-600 text-white px-2 py-1 rounded-full">
                                            📌 PINNED
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <!-- Media First (if available) -->
                                <?php
                                $announcementModel = new Announcement();
                                $announcementMedia = $announcementModel->getMedia((int)$a['id']);
                                if (!empty($announcementMedia)): ?>
                                    <div class="grid grid-cols-2 gap-1 max-h-56 overflow-hidden bg-slate-100">
                                        <?php foreach (array_slice($announcementMedia, 0, 2) as $m): ?>
                                            <?php if ($m['media_type'] === 'image'): ?>
                                                <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Announcement media" class="w-full h-40 object-cover">
                                            <?php else: ?>
                                                <div class="w-full h-40 flex items-center justify-center bg-slate-800">
                                                    <span class="text-3xl">🎬</span>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Announcement Content -->
                                <div class="p-5">
                                    <h3 class="font-bold text-slate-900 text-base">
                                        <?= htmlspecialchars($a['title']) ?>
                                    </h3>
                                    <p class="text-sm text-slate-700 mt-2 line-clamp-3">
                                        <?= htmlspecialchars(mb_substr($a['body'], 0, 160)) ?><?= mb_strlen($a['body']) > 160 ? '…' : '' ?>
                                    </p>
                                    <p class="text-xs text-slate-500 mt-3">
                                        By <?= htmlspecialchars($a['full_name'] ?? 'PACCPOLICY') ?> · <?= htmlspecialchars($a['created_at']) ?>
                                    </p>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <!-- Display Posts in Community Feed -->
                    <?php foreach ($recentPosts as $p): ?>
                        <article class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden hover:shadow-lg transition">
                            <!-- Media First (if available) -->
                            <?php
                            $postModel = new Post();
                            $media = $postModel->getPostMedia((int)$p['id']);
                            if (!empty($media)): ?>
                                <div class="grid grid-cols-2 gap-1 max-h-56 overflow-hidden bg-slate-100">
                                    <?php foreach (array_slice($media, 0, 2) as $m): ?>
                                        <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>">
                                            <?php if ($m['media_type'] === 'image'): ?>
                                                <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Post media" class="w-full h-40 object-cover hover:opacity-90 transition">
                                            <?php else: ?>
                                                <div class="w-full h-40 flex items-center justify-center bg-slate-800 hover:opacity-90 transition">
                                                    <span class="text-3xl">🎬</span>
                                                </div>
                                            <?php endif; ?>
                                        </a>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <!-- Post Content -->
                            <div class="p-5">
                                <!-- Post Header with Profile Image -->
                                <div class="flex items-start gap-3 mb-4">
                                    <!-- Profile Image -->
                                    <div class="flex-shrink-0">
                                        <?php
                                        $profileImage = $p['profile_image'] ?? null;
                                        $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                                        ?>
                                        <?php if ($imageUrl): ?>
                                            <img src="<?= $imageUrl ?>" alt="Profile" class="w-10 h-10 rounded-full object-cover border border-slate-200">
                                        <?php else: ?>
                                            <div class="w-10 h-10 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white text-sm font-bold">
                                                <?= strtoupper(substr($p['full_name'] ?? 'U', 0, 1)) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-semibold text-slate-800">
                                            <?= htmlspecialchars($p['full_name'] ?? $p['student_id']) ?>
                                        </p>
                                        <p class="text-xs text-slate-500">
                                            <?= htmlspecialchars($p['created_at']) ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Post Title and Body -->
                                <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="block group">
                                    <h3 class="font-bold text-slate-900 text-base line-clamp-2 group-hover:text-emerald-700 transition">
                                        <?= htmlspecialchars($p['title']) ?>
                                    </h3>
                                    <p class="text-sm text-slate-600 mt-2 line-clamp-3">
                                        <?= htmlspecialchars(mb_substr($p['body'], 0, 160)) ?><?= mb_strlen($p['body']) > 160 ? '…' : '' ?>
                                    </p>
                                </a>

                                <!-- Engagement Stats -->
                                <div class="flex items-center gap-4 mt-4 pt-4 border-t border-slate-100 text-sm text-slate-600">
                                    <span class="hover:text-red-600 transition">💬 <?= (int)($p['comments_count'] ?? 0) ?></span>
                                    <span class="hover:text-red-600 transition">❤️ <?= (int)($p['likes_count'] ?? 0) ?></span>
                                    <span class="hover:text-green-600 transition">🔄 <?= (int)($p['reposts_count'] ?? 0) ?></span>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <aside class="space-y-4 lg:col-start-4">
        <?php if (empty($_SESSION['user'])): ?>
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-4 space-y-3">
            <h2 class="font-semibold text-slate-800">Get Started</h2>
            <ol class="space-y-2 text-sm text-slate-600 list-decimal list-inside">
                <li>Register with your <span class="font-semibold">Student ID</span>.</li>
                <li>Complete your environmental profile and interests.</li>
                <li>Join discussions on climate, biodiversity, waste, and more.</li>
            </ol>
            <div class="flex gap-2 pt-2">
                <a href="<?= BASE_URL ?>/auth/register" class="flex-1 text-center bg-emerald-700 hover:bg-emerald-800 text-white text-sm py-2 rounded-lg">
                    Join the Community
                </a>
                <a href="<?= BASE_URL ?>/auth/login" class="flex-1 text-center border border-emerald-700 text-emerald-800 text-sm py-2 rounded-lg hover:bg-emerald-50">
                    Login
                </a>
            </div>
        </div>
        <?php endif; ?>
    </aside>
</section>
