<?php
// Get the current route for active tab
$currentTab = $_GET['tab'] ?? 'posts';
?>

<div class="min-h-screen bg-gradient-to-b from-blue-50 to-white p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-4xl font-bold text-gray-900 mb-2">My Dashboard</h1>
            <p class="text-gray-600">Track your engagement and contributions</p>
        </div>

        <div class="grid lg:grid-cols-3 gap-6">
            <!-- Left Column: Analytics Panel -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 sticky top-6">
                    <h2 class="text-xl font-bold text-gray-900 mb-6">📊 Your Analytics</h2>
                    
                    <!-- Engagement Score Card -->
                    <div class="bg-gradient-to-br from-purple-500 to-indigo-600 text-white rounded-lg p-4 mb-6">
                        <p class="text-sm font-medium opacity-90 mb-1">Engagement Score</p>
                        <p class="text-3xl font-bold"><?php echo $analytics['engagement_score'] ?? 0; ?></p>
                        <p class="text-xs opacity-75 mt-2">Based on activity</p>
                    </div>

                    <!-- Content Stats -->
                    <div class="space-y-4 mb-6">
                        <div class="flex justify-between items-center pb-3 border-b border-gray-200">
                            <span class="text-gray-700 font-medium">📝 Posts</span>
                            <span class="text-2xl font-bold text-blue-600"><?php echo $analytics['total_posts'] ?? 0; ?></span>
                        </div>
                        <div class="flex justify-between items-center pb-3 border-b border-gray-200">
                            <span class="text-gray-700 font-medium">💬 Comments Made</span>
                            <span class="text-2xl font-bold text-green-600"><?php echo $analytics['total_comments_made'] ?? 0; ?></span>
                        </div>
                    </div>

                    <!-- Engagement Stats -->
                    <h3 class="font-semibold text-gray-900 mb-3 text-sm">Engagement Received</h3>
                    <div class="space-y-3 mb-6 text-sm">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">❤️ Likes</span>
                            <span class="font-semibold text-red-600"><?php echo $analytics['total_likes_received'] ?? 0; ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">💬 Comments</span>
                            <span class="font-semibold text-blue-600"><?php echo $analytics['total_comments_received'] ?? 0; ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">🔄 Reposts</span>
                            <span class="font-semibold text-green-600"><?php echo $analytics['total_reposts_received'] ?? 0; ?></span>
                        </div>
                    </div>

                    <!-- Your Activity -->
                    <h3 class="font-semibold text-gray-900 mb-3 text-sm">Your Activity</h3>
                    <div class="space-y-3 text-sm">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">❤️ Likes Given</span>
                            <span class="font-semibold text-red-600"><?php echo $analytics['total_likes_given'] ?? 0; ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">🔄 Reposts Given</span>
                            <span class="font-semibold text-green-600"><?php echo $analytics['total_reposts_given'] ?? 0; ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Content Sections -->
            <div class="lg:col-span-2">
                <!-- Tab Navigation -->
                <div class="flex border-b border-gray-200 mb-6 bg-white rounded-t-lg overflow-x-auto sticky top-6">
                    <a href="?tab=posts" class="px-6 py-3 font-medium text-sm whitespace-nowrap <?php echo $currentTab === 'posts' ? 'text-blue-600 border-b-2 border-blue-600' : 'text-gray-600 hover:text-gray-900'; ?>">
                        📝 My Posts (<?php echo count($userPosts); ?>)
                    </a>
                    <a href="?tab=likes" class="px-6 py-3 font-medium text-sm whitespace-nowrap <?php echo $currentTab === 'likes' ? 'text-blue-600 border-b-2 border-blue-600' : 'text-gray-600 hover:text-gray-900'; ?>">
                        ❤️ Liked (<?php echo count($likedPosts); ?>)
                    </a>
                    <a href="?tab=reposts" class="px-6 py-3 font-medium text-sm whitespace-nowrap <?php echo $currentTab === 'reposts' ? 'text-blue-600 border-b-2 border-blue-600' : 'text-gray-600 hover:text-gray-900'; ?>">
                        🔄 Reposted (<?php echo count($repostedPosts); ?>)
                    </a>
                </div>

                <!-- Tab Content -->
                <div class="bg-white rounded-b-lg border border-gray-200 border-t-0">
                    <!-- My Posts Tab -->
                    <?php if ($currentTab === 'posts'): ?>
                        <div class="p-6">
                            <?php if (empty($userPosts)): ?>
                                <div class="text-center py-12">
                                    <p class="text-gray-500 text-lg">📝 You haven't created any posts yet</p>
                                    <a href="<?= BASE_URL ?>/posts/create" class="inline-block mt-4 bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition">
                                        Create Your First Post
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="space-y-4">
                                    <?php foreach ($userPosts as $post): ?>
                                        <div class="border border-gray-200 rounded-lg p-5 hover:shadow-md transition">
                                            <div class="flex justify-between items-start mb-3">
                                                <div class="flex items-center space-x-3 flex-1">
                                                    <?php
                                                    $initials = substr($post['full_name'] ?? 'U', 0, 2);
                                                    $avatar_path = "/uploads/profiles/{$post['user_id']}.jpg";
                                                    $avatar_exists = file_exists($_SERVER['DOCUMENT_ROOT'] . $avatar_path);
                                                    ?>
                                                    <?php if ($avatar_exists): ?>
                                                        <img src="<?php echo $avatar_path; ?>" alt="<?php echo htmlspecialchars($post['full_name']); ?>" class="w-10 h-10 rounded-full object-cover">
                                                    <?php else: ?>
                                                        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white font-bold text-sm">
                                                            <?php echo $initials; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div>
                                                        <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($post['full_name']); ?></p>
                                                        <p class="text-xs text-gray-500"><?php echo date('M d, Y H:i', strtotime($post['created_at'])); ?></p>
                                                    </div>
                                                </div>
                                                <div class="flex space-x-2">
                                                    <a href="/posts/edit/<?php echo $post['id']; ?>" class="text-blue-600 hover:text-blue-700 font-medium text-sm">✏️ Edit</a>
                                                    <form method="POST" action="/posts/delete/<?php echo $post['id']; ?>" style="display:inline;" onsubmit="return confirm('Delete this post?');">
                                                        <button type="submit" class="text-red-600 hover:text-red-700 font-medium text-sm">🗑️ Delete</button>
                                                    </form>
                                                </div>
                                            </div>

                                            <h3 class="font-bold text-lg text-gray-900 mb-2"><?php echo htmlspecialchars($post['title']); ?></h3>
                                            <p class="text-gray-700 text-sm mb-3 line-clamp-3"><?php echo htmlspecialchars(substr($post['body'], 0, 200)); ?><?php echo strlen($post['body']) > 200 ? '...' : ''; ?></p>

                                            <!-- Media Preview -->
                                            <?php
                                            $mediaPath = "/uploads/posts/{$post['id']}/";
                                            $mediaDir = $_SERVER['DOCUMENT_ROOT'] . $mediaPath;
                                            if (is_dir($mediaDir)) {
                                                $media = array_diff(scandir($mediaDir), ['.', '..']);
                                                if (!empty($media)): ?>
                                                    <div class="grid grid-cols-2 gap-2 mb-3 rounded-lg overflow-hidden max-h-40">
                                                        <?php foreach (array_slice($media, 0, 2) as $file): ?>
                                                            <?php
                                                            $ext = pathinfo($file, PATHINFO_EXTENSION);
                                                            if (in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif', 'webp'])):
                                                            ?>
                                                                <img src="<?php echo $mediaPath . $file; ?>" alt="Post media" class="w-full h-32 object-cover">
                                                            <?php elseif (in_array(strtolower($ext), ['mp4', 'webm', 'mov'])): ?>
                                                                <video src="<?php echo $mediaPath . $file; ?>" class="w-full h-32 object-cover" controls></video>
                                                            <?php endif; ?>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endif;
                                            }
                                            ?>

                                            <!-- Engagement Stats -->
                                            <div class="flex space-x-6 text-sm text-gray-600 border-t border-gray-100 pt-3">
                                                <span>💬 <?php echo $post['comments_count']; ?> Comments</span>
                                                <span>❤️ <?php echo $post['likes_count']; ?> Likes</span>
                                                <span>🔄 <?php echo $post['reposts_count']; ?> Reposts</span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                    <!-- Liked Posts Tab -->
                    <?php elseif ($currentTab === 'likes'): ?>
                        <div class="p-6">
                            <?php if (empty($likedPosts)): ?>
                                <div class="text-center py-12">
                                    <p class="text-gray-500 text-lg">❤️ You haven't liked any posts yet</p>
                                    <a href="<?= BASE_URL ?>/" class="inline-block mt-4 bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition">
                                        Explore Community Posts
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="space-y-4">
                                    <?php foreach ($likedPosts as $post): ?>
                                        <div class="border border-gray-200 rounded-lg p-5 hover:shadow-md transition">
                                            <div class="flex items-center space-x-3 mb-3">
                                                <?php
                                                $initials = substr($post['full_name'] ?? 'U', 0, 2);
                                                $avatar_path = "/uploads/profiles/{$post['user_id']}.jpg";
                                                $avatar_exists = file_exists($_SERVER['DOCUMENT_ROOT'] . $avatar_path);
                                                ?>
                                                <?php if ($avatar_exists): ?>
                                                    <img src="<?php echo $avatar_path; ?>" alt="<?php echo htmlspecialchars($post['full_name']); ?>" class="w-10 h-10 rounded-full object-cover">
                                                <?php else: ?>
                                                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white font-bold text-sm">
                                                        <?php echo $initials; ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($post['full_name']); ?></p>
                                                    <p class="text-xs text-gray-500"><?php echo date('M d, Y H:i', strtotime($post['created_at'])); ?></p>
                                                </div>
                                            </div>

                                            <h3 class="font-bold text-lg text-gray-900 mb-2"><?php echo htmlspecialchars($post['title']); ?></h3>
                                            <p class="text-gray-700 text-sm mb-3 line-clamp-2"><?php echo htmlspecialchars(substr($post['body'], 0, 150)); ?><?php echo strlen($post['body']) > 150 ? '...' : ''; ?></p>

                                            <!-- Engagement Stats with Like Highlight -->
                                            <div class="flex space-x-6 text-sm text-gray-600 border-t border-gray-100 pt-3">
                                                <span>💬 <?php echo $post['comments_count']; ?> Comments</span>
                                                <span class="text-red-600 font-semibold">❤️ <?php echo $post['likes_count']; ?> Likes</span>
                                                <span>🔄 <?php echo $post['reposts_count']; ?> Reposts</span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                    <!-- Reposted Posts Tab -->
                    <?php elseif ($currentTab === 'reposts'): ?>
                        <div class="p-6">
                            <?php if (empty($repostedPosts)): ?>
                                <div class="text-center py-12">
                                    <p class="text-gray-500 text-lg">🔄 You haven't reposted any posts yet</p>
                                    <a href="<?= BASE_URL ?>/" class="inline-block mt-4 bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition">
                                        Explore Community Posts
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="space-y-4">
                                    <?php foreach ($repostedPosts as $post): ?>
                                        <div class="border border-green-200 rounded-lg p-5 hover:shadow-md transition bg-green-50">
                                            <div class="flex items-start justify-between mb-3">
                                                <div class="flex items-center space-x-3">
                                                    <?php
                                                    $initials = substr($post['full_name'] ?? 'U', 0, 2);
                                                    $avatar_path = "/uploads/profiles/{$post['user_id']}.jpg";
                                                    $avatar_exists = file_exists($_SERVER['DOCUMENT_ROOT'] . $avatar_path);
                                                    ?>
                                                    <?php if ($avatar_exists): ?>
                                                        <img src="<?php echo $avatar_path; ?>" alt="<?php echo htmlspecialchars($post['full_name']); ?>" class="w-10 h-10 rounded-full object-cover">
                                                    <?php else: ?>
                                                        <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-white font-bold text-sm">
                                                            <?php echo $initials; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div>
                                                        <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($post['full_name']); ?></p>
                                                        <p class="text-xs text-gray-500"><?php echo date('M d, Y H:i', strtotime($post['created_at'])); ?></p>
                                                    </div>
                                                </div>
                                                <span class="bg-green-600 text-white px-3 py-1 rounded-full text-xs font-semibold">🔄 Reposted</span>
                                            </div>

                                            <h3 class="font-bold text-lg text-gray-900 mb-2"><?php echo htmlspecialchars($post['title']); ?></h3>
                                            <p class="text-gray-700 text-sm mb-3 line-clamp-2"><?php echo htmlspecialchars(substr($post['body'], 0, 150)); ?><?php echo strlen($post['body']) > 150 ? '...' : ''; ?></p>

                                            <!-- Engagement Stats with Repost Highlight -->
                                            <div class="flex space-x-6 text-sm text-gray-600 border-t border-green-200 pt-3">
                                                <span>💬 <?php echo $post['comments_count']; ?> Comments</span>
                                                <span>❤️ <?php echo $post['likes_count']; ?> Likes</span>
                                                <span class="text-green-600 font-semibold">🔄 <?php echo $post['reposts_count']; ?> Reposts</span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .line-clamp-3 {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>

