<?php
// Check if user is already logged in
if (!empty($_SESSION['user'])) {
    header('Location: ' . BASE_URL . '/home');
    exit;
}
?>

<div class="min-h-screen bg-slate-50 flex items-center justify-center px-4 py-12">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-8">
            <!-- Success Icon -->
            <div class="text-center mb-8">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-emerald-100 rounded-full mb-4">
                    <svg class="w-8 h-8 text-emerald-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-slate-900 mb-2">Password Reset Successful</h1>
                <p class="text-slate-600">Your password has been updated successfully</p>
            </div>

            <!-- Message -->
            <div class="mb-8 p-4 bg-emerald-50 border border-emerald-200 rounded-lg">
                <p class="text-emerald-700 text-sm">
                    You can now log in with your new password.
                </p>
            </div>

            <!-- Login Button -->
            <a
                href="<?= BASE_URL ?>/auth/login"
                class="block w-full text-center bg-emerald-700 hover:bg-emerald-800 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200"
            >
                Go to Login
            </a>

            <!-- Help Text -->
            <div class="mt-6 text-center">
                <p class="text-slate-600 text-sm">
                    Didn't request this change?
                    <br>
                    <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 hover:text-emerald-800 font-medium">
                        Contact support
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>
