<div class="max-w-xl mx-auto bg-white rounded-xl shadow-sm border border-slate-200 p-6">
    <h1 class="text-xl font-semibold text-slate-800 mb-4">Student Registration</h1>

    <?php if (!empty($errors)): ?>
        <div class="mb-4 rounded border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-700 space-y-1">
            <?php foreach ($errors as $e): ?>
                <p><?= htmlspecialchars($e) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post" class="grid gap-4 sm:grid-cols-2">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <div class="sm:col-span-2">
            <label class="block text-sm font-medium text-slate-700 mb-1" for="student_id">Student ID</label>
            <input
                type="text"
                id="student_id"
                name="student_id"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div class="sm:col-span-2">
            <label class="block text-sm font-medium text-slate-700 mb-1" for="full_name">Full Name</label>
            <input
                type="text"
                id="full_name"
                name="full_name"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="institution">Institution</label>
            <input
                type="text"
                id="institution"
                name="institution"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="programme">Programme / Field of Study</label>
            <input
                type="text"
                id="programme"
                name="programme"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="password">Password</label>
            <input
                type="password"
                id="password"
                name="password"
                required
                minlength="8"
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="password_confirm">Confirm Password</label>
            <input
                type="password"
                id="password_confirm"
                name="password_confirm"
                required
                minlength="8"
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div class="sm:col-span-2">
            <button
                type="submit"
                class="w-full bg-emerald-700 hover:bg-emerald-800 text-white text-sm font-medium py-2 rounded-lg"
            >
                Create Account
            </button>
        </div>

        <p class="sm:col-span-2 text-xs text-slate-500">
            By joining, you agree to community guidelines managed by PACCPOLICY. This platform is not managed by any school.
        </p>
    </form>
</div>

