<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">Announcements</h1>
</div>

<?php if (empty($announcements)): ?>
    <p class="text-sm text-slate-500">No announcements yet.</p>
<?php else: ?>
    <div class="space-y-4">
        <?php foreach ($announcements as $a): ?>
            <article class="bg-white rounded-xl shadow-sm border border-slate-200 p-4 hover:shadow-md transition">
                <!-- Announcement Header -->
                <header class="mb-3 flex items-start justify-between gap-2">
                    <div class="flex-1">
                        <h2 class="font-semibold text-slate-900 text-sm sm:text-base">
                            <?= htmlspecialchars($a['title']) ?>
                        </h2>
                        <p class="text-[11px] text-slate-400 mt-1">
                            <?= htmlspecialchars($a['created_at']) ?>
                            <?php if (!empty($a['full_name'])): ?>
                                · <?= htmlspecialchars($a['full_name']) ?> (PACCPOLICY)
                            <?php endif; ?>
                        </p>
                    </div>
                    <?php if (!empty($a['pinned'])): ?>
                        <span class="text-xs uppercase tracking-wide bg-emerald-700 text-emerald-50 px-2 py-1 rounded whitespace-nowrap">
                            📌 Pinned
                        </span>
                    <?php endif; ?>
                </header>
                
                <!-- Announcement Content -->
                <p class="text-sm text-slate-700 leading-relaxed mb-4">
                    <?= nl2br(htmlspecialchars($a['body'])) ?>
                </p>

                <!-- Media Preview -->
                <?php
                $announcementModel = new Announcement();
                $media = $announcementModel->getAnnouncementMedia((int)$a['id']);
                if (!empty($media)): ?>
                    <div class="mb-4 grid grid-cols-2 gap-2">
                        <?php foreach (array_slice($media, 0, 4) as $m): ?>
                            <div class="rounded-lg overflow-hidden bg-slate-100 aspect-square">
                                <?php if ($m['media_type'] === 'image'): ?>
                                    <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Announcement media" class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center bg-slate-800">
                                        <span class="text-2xl">🎬</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                        <?php if (count($media) > 4): ?>
                            <div class="rounded-lg overflow-hidden bg-slate-100 aspect-square flex items-center justify-center">
                                <span class="text-sm font-semibold text-slate-600">+<?= count($media) - 4 ?> more</span>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2 pt-3 border-t border-slate-100">
                    <?php if (!empty($_SESSION['user'])): ?>
                        <form method="post" action="<?= BASE_URL ?>/announcements/bookmark/<?= (int)$a['id'] ?>" class="flex-1">
                            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                            <button class="w-full text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-emerald-50 hover:border-emerald-200 hover:text-emerald-700 transition flex items-center justify-center gap-1">
                                🔖 Save
                            </button>
                        </form>
                        <button onclick="shareAnnouncement('<?= htmlspecialchars($a['title']) ?>')" class="flex-1 text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-emerald-50 hover:border-emerald-200 hover:text-emerald-700 transition flex items-center justify-center gap-1">
                            📤 Share
                        </button>
                    <?php else: ?>
                        <p class="text-xs text-slate-500 w-full text-center">
                            <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 hover:underline">Login</a> to save announcements
                        </p>
                    <?php endif; ?>
                </div>
            </article>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<script>
function shareAnnouncement(title) {
    if (navigator.share) {
        navigator.share({
            title: title,
            url: window.location.href
        }).catch(err => console.log('Share failed:', err));
    } else {
        const text = `${title}\n${window.location.href}`;
        navigator.clipboard.writeText(text).then(() => {
            alert('Announcement link copied to clipboard!');
        });
    }
}
</script>

