<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">Manage Announcements</h1>
    <div class="flex items-center gap-2">
        <a href="<?= BASE_URL ?>/admin" class="text-xs text-slate-500 hover:underline">Dashboard</a>
        <a href="<?= BASE_URL ?>/admin/newAnnouncement" class="text-xs sm:text-sm inline-flex items-center gap-1 bg-emerald-700 text-white px-3 py-1.5 rounded-lg hover:bg-emerald-800">
            New Announcement
        </a>
    </div>
</div>

<?php if (empty($announcements)): ?>
    <p class="text-sm text-slate-500">No announcements yet.</p>
<?php else: ?>
    <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-x-auto">
        <table class="min-w-full text-xs">
            <thead class="bg-slate-50 text-slate-600">
                <tr>
                    <th class="px-3 py-2 text-left">Title</th>
                    <th class="px-3 py-2 text-left">Pinned</th>
                    <th class="px-3 py-2 text-left">Active</th>
                    <th class="px-3 py-2 text-left">Created</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php foreach ($announcements as $a): ?>
                    <tr>
                        <td class="px-3 py-2">
                            <p class="font-medium text-slate-800 line-clamp-1"><?= htmlspecialchars($a['title']) ?></p>
                            <p class="text-[11px] text-slate-500 line-clamp-1"><?= htmlspecialchars(mb_substr($a['body'], 0, 80)) ?><?= mb_strlen($a['body']) > 80 ? '…' : '' ?></p>
                        </td>
                        <td class="px-3 py-2">
                            <?= !empty($a['pinned']) ? 'Yes' : 'No' ?>
                        </td>
                        <td class="px-3 py-2">
                            <?= !empty($a['is_active']) ? 'Active' : 'Expired' ?>
                        </td>
                        <td class="px-3 py-2 text-[11px] text-slate-500">
                            <?= htmlspecialchars($a['created_at']) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

