<?php

class Notification extends Model
{
    public function create(int $userId, string $type, array $data): int
    {
        $stmt = $this->db->prepare('INSERT INTO notifications (user_id, type, data)
            VALUES (:user_id, :type, :data)');
        $stmt->execute([
            'user_id' => $userId,
            'type'    => $type,
            'data'    => json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
        ]);
        return (int)$this->db->lastInsertId();
    }

    public function unreadForUser(int $userId, int $limit = 10): array
    {
        $stmt = $this->db->prepare('SELECT * FROM notifications 
            WHERE user_id = ? AND is_read = 0 
            ORDER BY created_at DESC 
            LIMIT ?');
        $stmt->execute([$userId, $limit]);
        return $stmt->fetchAll();
    }

    public function allForUser(int $userId, int $limit = 50, int $offset = 0): array
    {
        $stmt = $this->db->prepare('SELECT * FROM notifications 
            WHERE user_id = ? 
            ORDER BY created_at DESC 
            LIMIT ? OFFSET ?');
        $stmt->execute([$userId, $limit, $offset]);
        return $stmt->fetchAll();
    }

    public function markAllRead(int $userId): bool
    {
        $stmt = $this->db->prepare('UPDATE notifications SET is_read = 1 WHERE user_id = :user_id');
        return $stmt->execute(['user_id' => $userId]);
    }
}

