<?php

class Comment extends Model
{
    public function create(int $postId, int $userId, string $body): int
    {
        $stmt = $this->db->prepare('INSERT INTO comments (post_id, user_id, body) 
            VALUES (:post_id, :user_id, :body)');
        $stmt->execute([
            'post_id' => $postId,
            'user_id' => $userId,
            'body'    => $body,
        ]);
        return (int)$this->db->lastInsertId();
    }

    public function getByPost(int $postId): array
    {
        $stmt = $this->db->prepare('SELECT c.*, u.student_id, pr.full_name
            FROM comments c
            JOIN users u ON u.id = c.user_id
            LEFT JOIN profiles pr ON pr.user_id = u.id
            WHERE c.post_id = :post_id AND c.is_deleted = 0
            ORDER BY c.created_at ASC');
        $stmt->execute(['post_id' => $postId]);
        return $stmt->fetchAll();
    }
}

