<?php

class Bookmark extends Model
{
    public function togglePost(int $userId, int $postId): bool
    {
        $stmt = $this->db->prepare('SELECT id FROM bookmarks WHERE user_id = :user_id AND post_id = :post_id');
        $stmt->execute([
            'user_id' => $userId,
            'post_id' => $postId,
        ]);
        $existing = $stmt->fetch();

        if ($existing) {
            $stmt = $this->db->prepare('DELETE FROM bookmarks WHERE id = :id');
            return $stmt->execute(['id' => $existing['id']]);
        }

        $stmt = $this->db->prepare('INSERT INTO bookmarks (user_id, post_id) VALUES (:user_id, :post_id)');
        return $stmt->execute([
            'user_id' => $userId,
            'post_id' => $postId,
        ]);
    }

    public function toggleAnnouncement(int $userId, int $announcementId): bool
    {
        $stmt = $this->db->prepare('SELECT id FROM bookmarks WHERE user_id = :user_id AND announcement_id = :announcement_id');
        $stmt->execute([
            'user_id'          => $userId,
            'announcement_id'  => $announcementId,
        ]);
        $existing = $stmt->fetch();

        if ($existing) {
            $stmt = $this->db->prepare('DELETE FROM bookmarks WHERE id = :id');
            return $stmt->execute(['id' => $existing['id']]);
        }

        $stmt = $this->db->prepare('INSERT INTO bookmarks (user_id, announcement_id) VALUES (:user_id, :announcement_id)');
        return $stmt->execute([
            'user_id'         => $userId,
            'announcement_id' => $announcementId,
        ]);
    }

    public function getSavedForUser(int $userId): array
    {
        $sql = 'SELECT b.*, 
                    p.title AS post_title, p.body AS post_body,
                    a.title AS announcement_title, a.body AS announcement_body
                FROM bookmarks b
                LEFT JOIN posts p ON p.id = b.post_id
                LEFT JOIN announcements a ON a.id = b.announcement_id
                WHERE b.user_id = :user_id
                ORDER BY b.created_at DESC';
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['user_id' => $userId]);
        return $stmt->fetchAll();
    }
}

