<?php

class SearchController extends Controller
{
    public function index(): void
    {
        $q = trim($_GET['q'] ?? '');

        $results = [
            'posts'         => [],
            'announcements' => [],
            'users'         => [],
        ];

        if ($q !== '') {
            $like = '%' . $q . '%';
            $db   = Database::getInstance()->getConnection();

            // Posts
            $stmt = $db->prepare('SELECT p.id, p.title, p.body, p.created_at, pr.full_name 
                FROM posts p
                JOIN users u ON u.id = p.user_id
                LEFT JOIN profiles pr ON pr.user_id = u.id
                WHERE p.is_deleted = 0
                  AND (p.title LIKE :q OR p.body LIKE :q)
                ORDER BY p.created_at DESC
                LIMIT 20');
            $stmt->execute(['q' => $like]);
            $results['posts'] = $stmt->fetchAll();

            // Announcements
            $stmt = $db->prepare('SELECT a.id, a.title, a.body, a.created_at
                FROM announcements a
                WHERE a.title LIKE :q OR a.body LIKE :q
                ORDER BY a.created_at DESC
                LIMIT 20');
            $stmt->execute(['q' => $like]);
            $results['announcements'] = $stmt->fetchAll();

            // Users
            $stmt = $db->prepare('SELECT u.id, u.student_id, p.full_name, p.institution, p.programme
                FROM users u
                LEFT JOIN profiles p ON p.user_id = u.id
                WHERE u.student_id LIKE :q
                   OR p.full_name LIKE :q
                   OR p.institution LIKE :q
                   OR p.programme LIKE :q
                ORDER BY p.full_name ASC
                LIMIT 20');
            $stmt->execute(['q' => $like]);
            $results['users'] = $stmt->fetchAll();
        }

        $this->view('search/index', [
            'title'   => 'Search',
            'query'   => $q,
            'results' => $results,
        ]);
    }
}

