<?php

class HomeController extends Controller
{
    public function index(): void
    {
        $announcementModel = new Announcement();
        $postModel = new Post();

        // Get pinned announcements (highest priority)
        $pinnedAnnouncements = $announcementModel->getPinned();
        
        // Get all active announcements for community section
        $announcements = $announcementModel->getActive(50, 0);
        
        // Get recent posts from all users (latest first)
        $recentPosts = $postModel->getRecent(20, 0);

        $this->view('home/index', [
            'title' => 'EELL Community - Welcome',
            'pinnedAnnouncements' => $pinnedAnnouncements,
            'announcements' => $announcements,
            'recentPosts' => $recentPosts,
        ]);
    }
}

