<?php

class DashboardController extends Controller
{
    public function index(): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        $userId = (int)$_SESSION['user']['id'];

        $postModel    = new Post();
        $likeModel    = new Like();
        $repostModel  = new Repost();
        $commentModel = new Comment();
        $db           = Database::getInstance()->getConnection();

        // Get all posts created by user
        $userPosts = $postModel->getByUser($userId);

        // Get posts liked by user
        $likedPostIds = $likeModel->getPostsLikedByUser($userId);
        $likedPosts = [];
        if (!empty($likedPostIds)) {
            foreach ($likedPostIds as $id) {
                $post = $postModel->getByIdWithEngagement($id);
                if ($post) {
                    $likedPosts[] = $post;
                }
            }
        }

        // Get posts reposted by user
        $repostedPostIds = $repostModel->getPostsRepostedByUser($userId);
        $repostedPosts = [];
        if (!empty($repostedPostIds)) {
            foreach ($repostedPostIds as $id) {
                $post = $postModel->getByIdWithEngagement($id);
                if ($post) {
                    $repostedPosts[] = $post;
                }
            }
        }

        // Calculate analytics
        $analytics = [
            'total_posts' => count($userPosts),
            'total_likes_received' => (int)$db->query(
                "SELECT COUNT(*) FROM likes l
                 JOIN posts p ON p.id = l.post_id
                 WHERE p.user_id = $userId"
            )->fetchColumn(),
            'total_comments_received' => (int)$db->query(
                "SELECT COUNT(*) FROM comments c
                 JOIN posts p ON p.id = c.post_id
                 WHERE p.user_id = $userId AND c.is_deleted = 0"
            )->fetchColumn(),
            'total_reposts_received' => (int)$db->query(
                "SELECT COUNT(*) FROM reposts r
                 JOIN posts p ON p.id = r.post_id
                 WHERE p.user_id = $userId"
            )->fetchColumn(),
            'total_likes_given' => count($likedPosts),
            'total_reposts_given' => count($repostedPosts),
            'total_comments_made' => (int)$db->query(
                "SELECT COUNT(*) FROM comments WHERE user_id = $userId AND is_deleted = 0"
            )->fetchColumn(),
        ];

        // Calculate engagement score
        $analytics['engagement_score'] = $analytics['total_likes_received'] + 
                                        ($analytics['total_comments_received'] * 2) + 
                                        ($analytics['total_reposts_received'] * 3);

        $this->view('dashboard/index', [
            'title'         => 'My Dashboard',
            'userPosts'     => $userPosts,
            'likedPosts'    => $likedPosts,
            'repostedPosts' => $repostedPosts,
            'analytics'     => $analytics,
        ]);
    }
}

