## EELL Community Web Application (PACCPOLICY, Ghana)

Custom PHP MVC community platform for Environmental Education and Lifelong Learning (EELL) students in Ghana. Managed by **PACCPOLICY**, not by individual schools. Authentication is based on **Student ID + password**.

### Stack

- **Backend**: PHP 8+, custom MVC (no framework)
- **Frontend**: Tailwind CSS (via CDN)
- **Database**: MySQL 5.7+ / MariaDB
- **Auth**: Session-based, password hashing with `password_hash`

### Folder structure

- `public/` &mdash; web root, entry at `index.php`
- `core/` &mdash; lightweight MVC core (`Database`, `Model`, `Controller`)
- `app/controllers/` &mdash; route handlers (e.g. `HomeController`, `AuthController`)
- `app/models/` &mdash; database models (`User`, etc.)
- `app/views/` &mdash; PHP + Tailwind views
- `database.sql` &mdash; schema for all tables

### Running locally (XAMPP on Windows)

1. Copy this project folder to `c:\xampp\htdocs\ccpp`.
2. Create a MySQL database, e.g. `eell_community`.
3. Import `database.sql` in phpMyAdmin (or via CLI).
4. Ensure Apache is running and browse to `http://localhost/ccpp/public/`.
5. Configure environment variables or `putenv()` calls (e.g. in `public/index.php`) for:
   - `DB_HOST`, `DB_NAME`, `DB_USER`, `DB_PASS`.

### Authentication

- Students register with:
  - Student ID
  - Full name
  - Institution
  - Programme / field of study
- Passwords are hashed with `password_hash`.
- One account per Student ID (enforced by a unique index).
- Session-based login with session ID regeneration and CSRF tokens for forms.

#### Admin Account (PACCPOLICY)

A super admin account is available for platform management:

- **Student ID**: `admin_paccpolicy`
- **Password**: `Paccpolicy@Admin123`

This account has access to:
- Admin panel with user management
- Announcement creation and management
- User role assignment
- Platform moderation tools

**Important**: Change this password in production!

#### Password Reset

Users can reset their password via email:
1. Click "Forgot Password?" on the login page
2. Enter your Student ID
3. You'll receive a reset link (valid for 1 hour)
4. Click the link and set a new password

Password reset tokens are single-use and expire after 1 hour for security.

### Extending the system

The current skeleton includes:

- Public landing page with space for announcements and trending posts.
- Registration and login flows.
- Database schema for:
  - users, profiles, announcements, posts, comments
  - likes, bookmarks, messages, notifications, roles, engagement_stats

To complete all functional requirements:

- Add controllers and views for:
  - Posts & comments (create, edit, delete, like, bookmark, trending)
  - Announcements (admin CRUD + pin/unpin)
  - Private messages & notifications
  - Admin dashboard (user moderation, content moderation, engagement stats)
- Implement role checks using `Controller::requireRole(['admin', 'moderator'])`.
- Add search endpoints (posts, announcements, users) with pagination.

### Deployment notes

- Place the contents on a PHP 8+ server and configure the web root to `public/`.
- Set secure session settings:
  - Use HTTPS in production.
  - Ensure `cookie_secure = true`, `cookie_httponly = true`, `SameSite=Lax or Strict`.
- Restrict write permissions for PHP files and config.
- Periodically back up the MySQL database.

